#include "Multiselector.h"
using namespace std;

namespace MiniGUI {
    const int kPanelWidth = 300;

    Multiselector::Multiselector(ProblemHandler* handler,
                                 const Vector<string>& options,
                                 Mode mode) : options(options), mode(mode) {
        panel = new GContainer(GContainer::LAYOUT_GRID);
        panel->addToGrid(prev = new GButton("←"), 1, 0);
        panel->addToGrid(label = new GLabel(options.isEmpty()? "-" : options[0]), 0, 0, 1, 2);
        panel->addToGrid(next = new GButton("→"), 1, 1);
        panel->setWidth(kPanelWidth);

        handler->add(panel);
    }

    /* Returns what's selected, if there is anything. */
    Optional<string> Multiselector::selection() const {
        auto index = selectedIndex();
        if (index == Nothing) return Nothing;

        return options[index.value()];
    }

    /* Returns the INDEX of what's selected, if there is
     * anything.
     */
    Optional<int> Multiselector::selectedIndex() const {
        if (options.isEmpty()) return Nothing;
        return cursor;
    }

    bool Multiselector::handleEvent(GObservable* source) {
        if (source == prev) {
            /* Edge case: Ignore empty options list. */
            if (!options.isEmpty()) {
                cursor--;
                if (cursor < 0) cursor = options.size() - 1;

                updateDisplay();
            }
            return true;
        }
        else if (source == next) {
            /* Edge case: Ignore empty options list. */
            if (!options.isEmpty()) {
                cursor++;
                if (cursor == options.size()) cursor = 0;

                updateDisplay();
            }
            return true;
        }
        return false;
    }

    void Multiselector::updateDisplay() {
        if (!options.isEmpty()) {
            label->setText(options[cursor]);
        }
    }
}
